/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

import jas.Annotation;
import jas.AsciiCP;
import jas.CP;
import jas.Catchtable;
import jas.ClassCP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.ConstAttr;
import jas.DeprecatedAttr;
import jas.DoubleCP;
import jas.ExceptAttr;
import jas.FieldCP;
import jas.FloatCP;
import jas.GenericAttr;
import jas.IincInsn;
import jas.Insn;
import jas.IntegerCP;
import jas.InterfaceCP;
import jas.InvokeinterfaceInsn;
import jas.Label;
import jas.LabelOrOffset;
import jas.LineTableAttr;
import jas.LocalVarEntry;
import jas.LocalVarTableAttr;
import jas.LocalVarTypeTableAttr;
import jas.LongCP;
import jas.LookupswitchInsn;
import jas.Method;
import jas.MethodCP;
import jas.MultiarrayInsn;
import jas.SignatureAttr;
import jas.StackMap;
import jas.StringCP;
import jas.TableswitchInsn;
import jas.Var;
import jas.VerifyFrame;
import jas.jasError;
import jasmin.InsnInfo;
import jasmin.Scanner;
import jasmin.ScannerUtils;
import jasmin.parser;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassFile {
    private static final boolean PARSER_DEBUG = false;
    String filename;
    ClassEnv class_env;
    String class_name;
    String source_name;
    Scanner scanner;
    ExceptAttr except_attr;
    Catchtable catch_table;
    LocalVarTableAttr var_table;
    LocalVarTypeTableAttr vtype_table;
    LineTableAttr line_table;
    CodeAttr code;
    Method cur_method;
    Var cur_field;
    Hashtable labels;
    StackMap stackmap;
    VerifyFrame verifyframe;
    Annotation cur_annotation;
    int line_label_count;
    int line_num;
    int stack_map_label_count;
    boolean auto_number;
    boolean class_header;
    Insn buffered_insn;
    Vector switch_vec;
    int low_value;
    int high_value;
    static final String BGN_METHOD = "jasmin_reserved_bgnmethod:";
    static final String END_METHOD = "jasmin_reserved_endmethod:";
    int errors;

    void report_error(String msg) {
        this.report_error(msg, false);
    }

    void report_error(String msg, boolean BadIntVal) {
        ++this.errors;
        System.err.print(this.filename + ":");
        if (this.scanner == null) {
            System.err.println(" " + msg + ".");
        } else {
            int dia_charpos;
            int dia_linnum;
            String dia_line;
            if (BadIntVal && this.scanner.char_num >= 0) {
                dia_line = this.scanner.int_line;
                dia_linnum = this.scanner.int_line_num;
                dia_charpos = this.scanner.int_char_num;
            } else {
                dia_line = this.scanner.line.toString();
                dia_linnum = this.scanner.line_num;
                dia_charpos = this.scanner.char_num;
            }
            System.err.println(dia_linnum + ": " + msg + ".");
            if (this.scanner.char_num >= 0) {
                System.err.println(dia_line);
                for (int i = 0; i < dia_charpos; ++i) {
                    if (dia_line.charAt(i) == '\t') {
                        System.err.print("\t");
                        continue;
                    }
                    System.err.print(" ");
                }
                System.err.println("^");
            }
        }
    }

    void setSource(String name) {
        this.source_name = name;
    }

    void setVersion(Number version) {
        String str = version.toString();
        int idx = str.indexOf(".");
        if (!(version instanceof Float) || idx == -1) {
            this.report_error("invalid bytecode version number : " + str);
        }
        this.class_env.setVersion(Short.parseShort(str.substring(0, idx)), Short.parseShort(str.substring(idx + 1, str.length())));
    }

    void setClass(String name, short acc) {
        this.class_name = name;
        this.class_env.setClass(new ClassCP(name));
        this.class_env.setClassAccess(acc);
        this.class_header = true;
    }

    void setSuperClass(String name) {
        this.class_env.setSuperClass(new ClassCP(name));
    }

    void addInterface(String name) {
        this.class_env.addInterface(new ClassCP(name));
    }

    void setSourceDebugExtension(String str) {
        this.class_env.setSourceDebugExtension(str);
    }

    void setEnclosingMethod(String str) {
        try {
            if (str.indexOf("(") != -1) {
                String[] split = ScannerUtils.splitClassMethodSignature(str);
                this.class_env.setEnclosingMethod(split[0], split[1], split[2]);
            } else {
                this.class_env.setEnclosingMethod(str, null, null);
            }
        }
        catch (IllegalArgumentException e) {
            this.report_error(e.toString());
        }
    }

    private static void opened_annotation(String fld) throws jasError {
        throw new jasError("Skipped .end annotation in " + fld);
    }

    private static void outside(String dir) throws jasError {
        throw new jasError("illegal use of " + dir + " outside of method/field definition or class header");
    }

    public void endHeader() throws jasError {
        if (this.cur_annotation != null) {
            ClassFile.opened_annotation("class header");
        }
        this.class_env.endHeader();
        this.class_header = false;
    }

    void setSignature(String str) throws jasError {
        SignatureAttr sig = new SignatureAttr(str);
        if (this.cur_method != null) {
            this.cur_method.setSignature(sig);
        } else if (this.cur_field != null) {
            this.cur_field.setSignature(sig);
        } else if (this.class_header) {
            this.class_env.setSignature(str);
        } else {
            ClassFile.outside(".signature");
        }
    }

    void setDeprecated() throws jasError {
        DeprecatedAttr depr = new DeprecatedAttr();
        if (this.cur_method != null) {
            this.cur_method.setDeprecated(depr);
        } else if (this.cur_field != null) {
            this.cur_field.setDeprecated(depr);
        } else if (this.class_header) {
            this.class_env.setDeprecated(depr);
        } else {
            ClassFile.outside(".deprecated");
        }
    }

    void addGenericAttr(String name, String file) throws IOException, jasError {
        GenericAttr gattr = new GenericAttr(name, file);
        if (this.cur_method != null) {
            this.flushInsnBuffer();
            if (this.code != null) {
                this.code.addGenericAttr(gattr);
            } else {
                this.cur_method.addGenericAttr(gattr);
            }
        } else if (this.cur_field != null) {
            this.cur_field.addGenericAttr(gattr);
        } else if (this.class_header) {
            this.class_env.addGenericAttr(gattr);
        } else {
            ClassFile.outside(".attribute");
        }
    }

    public void addInner(short iacc, String name, String inner, String outer) {
        this.class_env.addInnerClass(iacc, name, inner, outer);
    }

    private static void annotation_internal() throws jasError {
        throw new jasError("logic error in .annotation parsing");
    }

    void addAnnotation() throws jasError {
        if (this.cur_method == null) {
            Annotation.ParserError();
        }
        this.cur_annotation = this.cur_method.addAnnotation();
    }

    void addAnnotation(boolean visible, String clname, int paramnum) throws jasError {
        if (this.cur_method == null) {
            Annotation.ParserError();
        }
        this.cur_annotation = this.cur_method.addAnnotation(visible, clname, paramnum);
    }

    void addAnnotation(boolean visible, String clname) throws jasError {
        if (this.cur_method != null) {
            this.cur_annotation = this.cur_method.addAnnotation(visible, clname);
        } else if (this.cur_field != null) {
            this.cur_annotation = this.cur_field.addAnnotation(visible, clname);
        } else if (this.class_header) {
            this.cur_annotation = this.class_env.addAnnotation(visible, clname);
        } else {
            ClassFile.outside(".annotation");
        }
    }

    void addAnnotationField(String name, String type, String add) throws jasError {
        if (this.cur_annotation == null) {
            ClassFile.annotation_internal();
        }
        this.cur_annotation.addField(name, type, add);
    }

    void addAnnotationValue(Object value) throws jasError {
        if (this.cur_annotation == null) {
            ClassFile.annotation_internal();
        }
        this.cur_annotation.addValue(value);
    }

    void nestAnnotation() throws jasError {
        if (this.cur_annotation == null) {
            ClassFile.annotation_internal();
        }
        this.cur_annotation = this.cur_annotation.nestAnnotation();
    }

    void endAnnotation() throws jasError {
        if (this.cur_annotation == null) {
            throw new jasError(".end annotation without .annotation");
        }
        this.cur_annotation = this.cur_annotation.endAnnotation();
    }

    /*
     * WARNING - void declaration
     */
    void beginField(short access, String name, String desc, Object value) throws jasError {
        ConstAttr ca = null;
        if (value != null) {
            void var6_6;
            CP cp;
            if (value instanceof Integer) {
                cp = new IntegerCP((Integer)value);
            } else if (value instanceof Float) {
                cp = new FloatCP(((Float)value).floatValue());
            } else if (value instanceof Double) {
                cp = new DoubleCP((Double)value);
            } else if (value instanceof Long) {
                cp = new LongCP((Long)value);
            } else if (value instanceof String) {
                cp = new StringCP((String)value);
            } else {
                throw new jasError("usupported value type");
            }
            ca = new ConstAttr((CP)var6_6);
        }
        this.cur_field = new Var(access, new AsciiCP(name), new AsciiCP(desc), ca);
    }

    void endField() throws jasError {
        if (this.cur_field == null) {
            throw new jasError(".end field without .field");
        }
        if (this.cur_annotation != null) {
            ClassFile.opened_annotation("field");
        }
        this.class_env.addField(this.cur_field);
        this.cur_field = null;
    }

    void addField(short access, String name, String desc, String sig, Object value) throws jasError {
        this.beginField(access, name, desc, value);
        if (sig != null) {
            this.cur_field.setSignature(new SignatureAttr(sig));
        }
        this.endField();
    }

    void newMethod(String name, String descriptor, int access) {
        this.labels = new Hashtable();
        this.code = null;
        this.except_attr = null;
        this.catch_table = null;
        this.var_table = null;
        this.vtype_table = null;
        this.line_table = null;
        this.line_label_count = 0;
        this.stack_map_label_count = 0;
        this.stackmap = null;
        this.verifyframe = null;
        this.cur_method = new Method((short)access, new AsciiCP(name), new AsciiCP(descriptor));
    }

    void endMethod() throws jasError {
        if (this.cur_method == null) {
            throw new jasError(".end method without .method");
        }
        if (this.cur_annotation != null) {
            ClassFile.opened_annotation("method");
        }
        if (this.code != null) {
            this.plantLabel(END_METHOD);
            this.flushInsnBuffer();
            if (this.catch_table != null) {
                this.code.setCatchtable(this.catch_table);
            }
            if (this.var_table != null) {
                this.code.setLocalVarTable(this.var_table);
            }
            if (this.vtype_table != null) {
                this.code.setLocalVarTypeTable(this.vtype_table);
            }
            if (this.line_table != null) {
                this.code.setLineTable(this.line_table);
            }
            if (this.stackmap != null) {
                this.code.setStackMap(this.stackmap);
            }
        }
        this.cur_method.setCode(this.code, this.except_attr);
        this.class_env.addMethod(this.cur_method);
        this.cur_method = null;
        this.code = null;
        this.labels = null;
        this.catch_table = null;
        this.line_table = null;
        this.var_table = null;
        this.vtype_table = null;
        this.stackmap = null;
        this.verifyframe = null;
    }

    private Vector prevStack(int count) throws jasError {
        Vector prev = null;
        if (this.stackmap != null) {
            prev = this.stackmap.getLastFrame(count);
        }
        return prev;
    }

    void beginStack(boolean copy) throws jasError {
        Vector prev = null;
        if (copy) {
            prev = this.prevStack(0);
        }
        this.verifyframe = new VerifyFrame(prev);
    }

    void beginStack(int n) throws jasError {
        if (n <= 0) {
            throw new jasError("Invalid counter", true);
        }
        this.verifyframe = new VerifyFrame(this.prevStack(n));
    }

    void plantStackOffset(int n) {
        try {
            this.verifyframe.setOffset(n);
        }
        catch (jasError e) {
            this.report_error(e.toString());
        }
    }

    void plantStackOffset(String label) throws jasError {
        Label l = this.getLabel(label);
        try {
            this.verifyframe.setOffset(l);
        }
        catch (jasError e) {
            this.report_error(e.toString());
        }
    }

    void plantStackLocals(String item, String val) {
        try {
            this.verifyframe.addLocalsItem(item, val);
        }
        catch (jasError e) {
            this.report_error(e.toString());
        }
    }

    void plantStackStack(String item, String val) {
        try {
            this.verifyframe.addStackItem(item, val);
        }
        catch (jasError e) {
            this.report_error(e.toString());
        }
    }

    void endStack() {
        if (!this.verifyframe.haveOffset()) {
            String l = "jasmin_reserved_SM:" + this.stack_map_label_count++;
            try {
                this.plantLabel(l);
                this.verifyframe.setOffset(this.getLabel(l));
            }
            catch (jasError e) {
                this.report_error(e.toString());
            }
        }
        if (this.stackmap == null) {
            this.stackmap = new StackMap(this.class_env);
        }
        this.stackmap.addFrame(this.verifyframe);
        this.verifyframe = null;
    }

    void plant(String name) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        this.autoNumber();
        this.flushInsnBuffer();
        if (!insn.args.equals("")) {
            throw new jasError("Missing arguments for instruction " + name);
        }
        this.bufferInsn(new Insn(insn.opcode));
    }

    void plantRelativeGoto(String name, int val) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        if (insn.args.equals("label")) {
            this.bufferInsn(new Insn(insn.opcode, val, true));
        } else {
            this.plant(name, val);
        }
    }

    void plant(String name, int v1, int v2) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        this.autoNumber();
        this.flushInsnBuffer();
        if (!insn.args.equalsIgnoreCase("ii")) {
            throw new jasError("Bad arguments for instruction " + name);
        }
        this.bufferInsn(new IincInsn(v1, v2, insn.args.charAt(0) == 'I'));
    }

    void plant(String name, int val) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        CodeAttr code = this._getCode();
        this.autoNumber();
        this.flushInsnBuffer();
        if (insn.args.equalsIgnoreCase("i")) {
            this.bufferInsn(new Insn(insn.opcode, val, insn.args.charAt(0) == 'I'));
        } else if (insn.args.equals("constant")) {
            this.bufferInsn(new Insn(insn.opcode, new IntegerCP(val)));
        } else if (insn.args.equals("bigconstant")) {
            this.bufferInsn(new Insn(insn.opcode, new LongCP(val)));
        } else if (insn.args.equals("label")) {
            this.plant(name, String.valueOf(val));
        } else {
            throw new jasError("Bad arguments for instruction " + name);
        }
    }

    void plant(String name, Number val) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        CodeAttr code = this._getCode();
        this.autoNumber();
        this.flushInsnBuffer();
        if (insn.args.equalsIgnoreCase("i") && val instanceof Integer) {
            this.bufferInsn(new Insn(insn.opcode, val.intValue(), insn.args.charAt(0) == 'I'));
        } else if (insn.args.equals("constant")) {
            if (val instanceof Integer || val instanceof Long) {
                this.bufferInsn(new Insn(insn.opcode, new IntegerCP(val.intValue())));
            } else if (val instanceof Float || val instanceof Double) {
                this.bufferInsn(new Insn(insn.opcode, new FloatCP(val.floatValue())));
            }
        } else if (insn.args.equals("bigconstant")) {
            if (val instanceof Integer || val instanceof Long) {
                this.bufferInsn(new Insn(insn.opcode, new LongCP(val.longValue())));
            } else if (val instanceof Float || val instanceof Double) {
                this.bufferInsn(new Insn(insn.opcode, new DoubleCP(val.doubleValue())));
            }
        } else {
            throw new jasError("Bad arguments for instruction " + name);
        }
    }

    void plantString(String name, String val) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        this.autoNumber();
        this.flushInsnBuffer();
        if (!insn.args.equals("constant")) {
            throw new jasError("Bad arguments for instruction " + name);
        }
        this.bufferInsn(new Insn(insn.opcode, new StringCP(val)));
    }

    void plant(String name, String val, int nargs) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        CodeAttr code = this._getCode();
        this.autoNumber();
        this.flushInsnBuffer();
        if (insn.args.equals("interface")) {
            String[] split = ScannerUtils.splitClassMethodSignature(val);
            this.bufferInsn(new InvokeinterfaceInsn(new InterfaceCP(split[0], split[1], split[2]), nargs));
        } else if (insn.args.equals("marray")) {
            this.bufferInsn(new MultiarrayInsn(new ClassCP(val), nargs));
        } else {
            throw new jasError("Bad arguments for instruction " + name);
        }
    }

    void plant(String name, String val) throws jasError {
        InsnInfo insn = InsnInfo.get(name);
        CodeAttr code = this._getCode();
        this.autoNumber();
        this.flushInsnBuffer();
        if (insn.args.equals("method")) {
            String[] split = ScannerUtils.splitClassMethodSignature(val);
            this.bufferInsn(new Insn(insn.opcode, new MethodCP(split[0], split[1], split[2])));
        } else if (insn.args.equals("constant")) {
            this.bufferInsn(new Insn(insn.opcode, new ClassCP(val)));
        } else if (insn.args.equals("atype")) {
            int atype = 0;
            if (val.equals("boolean")) {
                atype = 4;
            } else if (val.equals("char")) {
                atype = 5;
            } else if (val.equals("float")) {
                atype = 6;
            } else if (val.equals("double")) {
                atype = 7;
            } else if (val.equals("byte")) {
                atype = 8;
            } else if (val.equals("short")) {
                atype = 9;
            } else if (val.equals("int")) {
                atype = 10;
            } else if (val.equals("long")) {
                atype = 11;
            } else {
                throw new jasError("Bad array type: " + name);
            }
            this.bufferInsn(new Insn(insn.opcode, atype, false));
        } else if (insn.args.indexOf("label") >= 0) {
            this.bufferInsn(new Insn(insn.opcode, this.getLabel(val), this.scanner.line_num));
        } else if (insn.args.equals("class")) {
            this.bufferInsn(new Insn(insn.opcode, new ClassCP(val)));
        } else {
            throw new jasError("(gloups)Bad arguments for instruction " + name);
        }
    }

    void plant(String name, String v1, String v2) throws jasError {
        String[] split;
        InsnInfo info = InsnInfo.get(name);
        CodeAttr code = this._getCode();
        this.autoNumber();
        this.flushInsnBuffer();
        if (info.args.equals("field")) {
            split = ScannerUtils.splitClassField(v1);
            if (split[1] == null) {
                throw new jasError("can't extract field from " + v1);
            }
        } else {
            throw new jasError("Bad arguments for instruction " + name);
        }
        this.bufferInsn(new Insn(info.opcode, new FieldCP(split[0], split[1], v2)));
    }

    void newLookupswitch() throws jasError {
        this.switch_vec = new Vector();
        this.autoNumber();
    }

    void addLookupswitch(int val, String label) throws jasError {
        this.switch_vec.addElement(new Integer(val));
        this.switch_vec.addElement(new LabelOrOffset(this.getLabel(label)));
    }

    void addLookupswitch(int val, int offset) throws jasError {
        this.switch_vec.addElement(new Integer(val));
        this.switch_vec.addElement(new LabelOrOffset(offset));
    }

    void endLookupswitch(String deflabel) throws jasError {
        this.flushInsnBuffer();
        Object[] offlabs = this.checkLookupswitch();
        int[] offsets = (int[])offlabs[0];
        LabelOrOffset[] labels = (LabelOrOffset[])offlabs[1];
        LabelOrOffset defl = new LabelOrOffset(this.getLabel(deflabel));
        this.bufferInsn(new LookupswitchInsn(defl, offsets, labels));
    }

    void endLookupswitch(int defoffset) throws jasError {
        this.flushInsnBuffer();
        Object[] offlabs = this.checkLookupswitch();
        int[] offsets = (int[])offlabs[0];
        LabelOrOffset[] labels = (LabelOrOffset[])offlabs[1];
        this.bufferInsn(new LookupswitchInsn(new LabelOrOffset(defoffset), offsets, labels));
    }

    private Object[] checkLookupswitch() {
        int n = this.switch_vec.size() >> 1;
        int[] offsets = new int[n];
        LabelOrOffset[] labels = new LabelOrOffset[n];
        Enumeration e = this.switch_vec.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            offsets[i] = (Integer)e.nextElement();
            labels[i] = (LabelOrOffset)e.nextElement();
            ++i;
        }
        Object[] result = new Object[]{offsets, labels};
        return result;
    }

    void newTableswitch(int lowval) throws jasError {
        this.newTableswitch(lowval, -1);
    }

    void newTableswitch(int lowval, int hival) throws jasError {
        this.switch_vec = new Vector();
        this.low_value = lowval;
        this.high_value = hival;
        this.autoNumber();
    }

    void addTableswitch(String label) throws jasError {
        this.switch_vec.addElement(new LabelOrOffset(this.getLabel(label)));
    }

    void addTableswitch(int offset) throws jasError {
        this.switch_vec.addElement(new LabelOrOffset(offset));
    }

    void endTableswitch(String deflabel) throws jasError {
        this.flushInsnBuffer();
        LabelOrOffset[] labels = this.checkTableswitch();
        this.bufferInsn(new TableswitchInsn(this.low_value, this.low_value + labels.length - 1, new LabelOrOffset(this.getLabel(deflabel)), labels));
    }

    void endTableswitch(int defoffset) throws jasError {
        this.flushInsnBuffer();
        LabelOrOffset[] labels = this.checkTableswitch();
        this.bufferInsn(new TableswitchInsn(this.low_value, this.low_value + labels.length - 1, new LabelOrOffset(defoffset), labels));
    }

    private LabelOrOffset[] checkTableswitch() {
        int n = this.switch_vec.size();
        LabelOrOffset[] labels = new LabelOrOffset[n];
        Enumeration e = this.switch_vec.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            labels[i] = (LabelOrOffset)e.nextElement();
            ++i;
        }
        if (this.high_value != -1 && this.high_value != this.low_value + n - 1) {
            this.report_error("tableswitch - given incorrect value for <high>");
        }
        return labels;
    }

    void setLine(int l) {
        this.line_num = l;
    }

    void autoNumber() throws jasError {
        if (this.auto_number) {
            this.addLineInfo(this.line_num);
        }
    }

    Label getLabel(String name) throws jasError {
        if (this.cur_method == null) {
            throw new jasError("illegal use of label outside of method definition");
        }
        Label lab = (Label)this.labels.get(name);
        if (lab == null) {
            lab = new Label(name);
            this.labels.put(name, lab);
        }
        return lab;
    }

    void plantLabel(String name) throws jasError {
        try {
            Integer.parseInt(name);
            this._getCode().addInsn(this.getLabel(name));
            this.flushInsnBuffer();
        }
        catch (NumberFormatException e) {
            this.flushInsnBuffer();
            this.bufferInsn(this.getLabel(name));
        }
    }

    void bufferInsn(Insn i) throws jasError {
        if (i == null) {
            throw new jasError("trying to buffer a null instruction");
        }
        if (this.buffered_insn != null) {
            this.flushInsnBuffer();
        }
        this.buffered_insn = i;
    }

    void flushInsnBuffer() throws jasError {
        if (this.buffered_insn != null) {
            this._getCode().addInsn(this.buffered_insn);
            this.buffered_insn = null;
        }
    }

    void addVar(String startLab, String endLab, String name, String desc, String sign, int var_num) throws jasError {
        if (startLab == null) {
            startLab = BGN_METHOD;
        }
        if (endLab == null) {
            endLab = END_METHOD;
        }
        Label slab = this.getLabel(startLab);
        Label elab = this.getLabel(endLab);
        if (this.var_table == null) {
            this.var_table = new LocalVarTableAttr();
        }
        this.var_table.addEntry(new LocalVarEntry(slab, elab, name, desc, var_num));
        if (sign != null) {
            if (this.vtype_table == null) {
                this.vtype_table = new LocalVarTypeTableAttr();
            }
            this.vtype_table.addEntry(new LocalVarEntry(slab, elab, name, sign, var_num));
        }
    }

    void addVar(int startOffset, int endOffset, String name, String desc, String sign, int var_num) throws jasError {
        if (this.var_table == null) {
            this.var_table = new LocalVarTableAttr();
        }
        this.var_table.addEntry(new LocalVarEntry(startOffset, endOffset, name, desc, var_num));
        if (sign != null) {
            if (this.vtype_table == null) {
                this.vtype_table = new LocalVarTypeTableAttr();
            }
            this.vtype_table.addEntry(new LocalVarEntry(startOffset, endOffset, name, sign, var_num));
        }
    }

    void addLineInfo(int line_num) throws jasError {
        String l = "jasmin_reserved_L:" + this.line_label_count++;
        if (this.line_table == null) {
            this.line_table = new LineTableAttr();
        }
        this.plantLabel(l);
        this.line_table.addEntry(this.getLabel(l), line_num);
    }

    void addLine(int line_num) throws jasError {
        if (!this.auto_number) {
            this.addLineInfo(line_num);
        }
    }

    void addThrow(String name) throws jasError {
        if (this.cur_method == null) {
            throw new jasError("illegal use of .throw outside of method definition");
        }
        if (this.except_attr == null) {
            this.except_attr = new ExceptAttr();
        }
        this.except_attr.addException(new ClassCP(name));
    }

    void addCatch(String name, String start_lab, String end_lab, String branch_lab) throws jasError {
        ClassCP class_cp = this.checkCatch(name);
        this.catch_table.addEntry(this.getLabel(start_lab), this.getLabel(end_lab), this.getLabel(branch_lab), (CP)class_cp);
    }

    void addCatch(String name, int start_off, int end_off, int branch_off) throws jasError {
        ClassCP class_cp = this.checkCatch(name);
        this.catch_table.addEntry(start_off, end_off, branch_off, (CP)class_cp);
    }

    short checkLimit(int v) throws jasError {
        if (v < 0 || v > 65535) {
            throw new jasError("Illegal limit value", true);
        }
        return (short)v;
    }

    void setStackSize(int v) throws jasError {
        this._getCode().setStackSize(this.checkLimit(v));
    }

    void setVarSize(int v) throws jasError {
        this._getCode().setVarSize(this.checkLimit(v));
    }

    private ClassCP checkCatch(String name) throws jasError {
        if (this.cur_method == null) {
            throw new jasError("illegal use of .catch outside of method definition");
        }
        if (this.catch_table == null) {
            this.catch_table = new Catchtable();
        }
        ClassCP class_cp = name.equals("all") ? null : new ClassCP(name);
        return class_cp;
    }

    CodeAttr _getCode() throws jasError {
        if (this.cur_method == null) {
            throw new jasError("illegal use of instruction outside of method definition");
        }
        if (this.code == null) {
            this.code = new CodeAttr();
            this.plantLabel(BGN_METHOD);
        }
        return this.code;
    }

    public void readJasmin(Reader input, String name, boolean numberLines) throws IOException, Exception {
        this.errors = 0;
        this.filename = name;
        this.source_name = name;
        this.cur_method = null;
        this.cur_field = null;
        this.cur_annotation = null;
        this.class_header = false;
        this.auto_number = numberLines;
        this.class_env = new ClassEnv();
        this.scanner = new Scanner(input);
        parser parse_obj = new parser(this, this.scanner);
        parse_obj.parse();
    }

    public int errorCount() {
        return this.errors;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void write(OutputStream outp) throws IOException, jasError {
        this.class_env.setSource(this.source_name);
        this.class_env.write(new DataOutputStream(outp));
    }
}

