/*
 * Decompiled with CFR 0.152.
 */
package coursesolutions;

import lab7.AbstractNode;
import lab7.NodeVisitor;
import lab7.ReflectiveVisitor;
import lab7.Type;
import lab8.AssignTypeRequiring;
import lab8.BinaryComputeIsh;
import lab8.BoolTypeProducing;
import lab8.CastNode;
import lab8.ClassDeclaring;
import lab8.FieldReferencing;
import lab8.FloatTypeProducing;
import lab8.IntTypeProducing;
import lab8.InvokeIsh;
import lab8.LocalReferencing;
import lab8.NewIsh;
import lab8.PrimType;
import lab8.RefType;
import lab8.ReturnIsh;
import lab8.StringTypeProducing;
import lab8.SymInfo;
import lab8.ThisIsh;
import lab8.TypeAsserting;
import lab8.TypeAttrs;
import lab8.UnaryComputeIsh;

public class CourseTypeSetVisitor
extends NodeVisitor {
    private Type classType;

    public CourseTypeSetVisitor() {
        this.setPrintStream(System.err);
    }

    public void perform(AbstractNode root) {
        root.accept((ReflectiveVisitor)this);
    }

    public void defaultVisit(Object o) {
        AbstractNode n = (AbstractNode)o;
        this.visitChildren(n);
    }

    public void visit(NewIsh ni) {
        AbstractNode n = (AbstractNode)ni;
        this.visitChildren(n);
        this.setType(ni, ni.getType());
    }

    public void visit(ClassDeclaring c) {
        this.classType = new RefType(c.getName());
        this.visitChildren((AbstractNode)c);
    }

    public void visit(ThisIsh t) {
        this.setType(t, this.classType);
    }

    public void visit(LocalReferencing r) {
        SymInfo si = r.getSymInfo();
        if (si != null) {
            TypeAttrs t = si.getType();
            this.setType(r, (Type)t);
        } else {
            this.err("null type" + r);
        }
    }

    public void visit(InvokeIsh inv) {
        this.visitChildren((AbstractNode)inv);
        this.setType(inv, inv.methodNode().getReturnType());
    }

    public void visit(ReturnIsh rt) {
        AbstractNode n = (AbstractNode)rt;
        this.visitChildren(n);
        if (n.getChild() != null) {
            this.setType(rt, n.getChild().getNodeType());
        } else {
            this.setType(rt, (Type)new PrimType("Void"));
        }
    }

    public void visit(FieldReferencing sr) {
        AbstractNode n = (AbstractNode)sr;
        this.visitChildren(n);
        this.setType(sr, sr.getResultingType());
    }

    public void visit(BoolTypeProducing btp) {
        this.visitChildren((AbstractNode)btp);
        this.setType(btp, (Type)new PrimType("Zoolean"));
    }

    public void visit(IntTypeProducing itp) {
        this.visitChildren((AbstractNode)itp);
        this.setType(itp, (Type)new PrimType("Int"));
    }

    public void visit(FloatTypeProducing ftp) {
        this.visitChildren((AbstractNode)ftp);
        this.setType(ftp, (Type)new PrimType("Float"));
    }

    public void visit(StringTypeProducing stp) {
        this.visitChildren((AbstractNode)stp);
        this.setType(stp, (Type)new RefType("java.lang.String"));
    }

    public void visit(TypeAsserting rtp) {
        this.visitChildren((AbstractNode)rtp);
        this.setType(rtp, rtp.getType());
    }

    public void visit(UnaryComputeIsh ui) {
        AbstractNode n = (AbstractNode)ui;
        this.visitChildren(n);
        this.setType(n, n.getChild().getNodeType());
    }

    public void visit(BinaryComputeIsh ei) {
        this.visitBothSame((AbstractNode)ei);
    }

    public void visit(CastNode n) {
        this.visitChildren((AbstractNode)n);
        this.setType(n, n.getAssignTypeNode().getNodeType());
    }

    public void visit(AssignTypeRequiring atr) {
        this.visitBothSame((AbstractNode)atr);
    }

    public void visitBothSame(AbstractNode n) {
        this.visitChildren(n);
        AbstractNode c1 = n.getChild();
        AbstractNode c2 = c1.getSib();
        if (!c1.getNodeType().equals(c2.getNodeType())) {
            this.err("Semantic error at " + n.dump() + ": assign requires same types" + "\nLeft child:" + c1.dump() + "\nRight child:" + c2.dump());
        }
        this.setType(n, c1.getNodeType());
    }

    public void setType(Object o, Type t) {
        AbstractNode n = (AbstractNode)o;
        n.setNodeType(t);
    }
}

