/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.PrintStream;

public class Listing {
    private static final String endl = "\n";
    private PrintStream ps;
    private static Listing staticListing;
    private int linenumber;
    private int col;
    private static boolean echoStdErr;

    static {
        echoStdErr = false;
    }

    public Listing(PrintStream ps, String message) {
        this.ps = ps;
        staticListing = this;
        this.startListing(message);
    }

    public Listing(PrintStream ps) {
        this(ps, "");
    }

    public static Listing get() {
        return staticListing;
    }

    public void startListing(String message) {
        this.out(message);
        this.linenumber = 0;
        this.col = 1;
        this.newLine(1);
    }

    public void endListing(String message) {
        this.out(message);
    }

    public int getLineNumber() {
        return this.linenumber;
    }

    public int getColNumber() {
        return this.col;
    }

    private static String makestrlen(String text, int len) {
        String ans = text;
        while (ans.length() < len) {
            ans = " " + ans;
        }
        return ans;
    }

    private static String makestrlen(int text, int len) {
        return Listing.makestrlen(String.valueOf(text), len);
    }

    public void newLine(int bump) {
        this.linenumber += bump;
        if (bump > 0) {
            this.col = 1;
            this.out(endl + Listing.makestrlen(this.linenumber, 7) + ": ");
        } else {
            this.out("\n*" + Listing.makestrlen(this.linenumber, 6) + ": ");
        }
    }

    public void echo(String text) {
        this.col += text.length();
        this.out(text);
    }

    public void StartMessage() {
        this.InsertMessage("^^^");
    }

    private void InsertMessage(String text) {
        this.newLine(0);
        int i = 1;
        while (i <= this.col) {
            this.out(" ");
            ++i;
        }
        this.out(text);
    }

    public void EndMessage() {
        this.InsertMessage("");
    }

    public void EmitMessage(String text) {
        this.StartMessage();
        this.out(text);
        if (echoStdErr) {
            System.err.println(text);
        }
        this.EndMessage();
    }

    public void warning(String text) {
        this.EmitMessage("Warning: " + text);
    }

    public void oops(String text) {
        this.EmitMessage(text);
        this.endListing("End.");
        System.err.println("Aborting due to error at line " + this.linenumber + " column " + this.col + endl);
        System.exit(1);
    }

    private void out(String text) {
        this.ps.print(text);
    }
}

