/*
 * Decompiled with CFR 0.152.
 */
package coursesolutions;

import hw4.AssignTypeRequiring;
import hw4.BinaryComputeIsh;
import hw4.BoolTypeProducing;
import hw4.CastNode;
import hw4.ClassDeclaring;
import hw4.FieldReferencing;
import hw4.FloatTypeProducing;
import hw4.IntTypeProducing;
import hw4.InvokeIsh;
import hw4.LocalReferencing;
import hw4.NewIsh;
import hw4.PrimType;
import hw4.RefType;
import hw4.ReturnIsh;
import hw4.StringTypeProducing;
import hw4.SymInfo;
import hw4.ThisIsh;
import hw4.TypeAsserting;
import hw4.TypeAttrs;
import hw4.UnaryComputeIsh;
import lab7.AbstractNode;
import lab7.NodeVisitor;
import lab7.Type;

public class CourseTypeSetVisitor
extends NodeVisitor {
    private Type classType;

    public CourseTypeSetVisitor() {
        this.setPrintStream(System.err);
    }

    @Override
    public void perform(AbstractNode root) {
        root.accept(this);
    }

    @Override
    public void defaultVisit(Object o) {
        AbstractNode n = (AbstractNode)o;
        this.visitChildren(n);
    }

    public void visit(NewIsh ni) {
        AbstractNode n = (AbstractNode)((Object)ni);
        this.visitChildren(n);
        this.setType(ni, ni.getType());
    }

    public void visit(ClassDeclaring c) {
        this.classType = new RefType(c.getName());
        this.visitChildren((AbstractNode)((Object)c));
    }

    public void visit(ThisIsh t) {
        this.setType(t, this.classType);
    }

    public void visit(LocalReferencing r) {
        SymInfo si = r.getSymInfo();
        if (si != null) {
            TypeAttrs t = si.getType();
            this.setType(r, t);
        } else {
            this.err("null type" + r);
        }
    }

    public void visit(InvokeIsh inv) {
        this.visitChildren((AbstractNode)((Object)inv));
        this.setType(inv, inv.methodNode().getReturnType());
    }

    public void visit(ReturnIsh rt) {
        AbstractNode n = (AbstractNode)((Object)rt);
        this.visitChildren(n);
        if (n.getChild() != null) {
            this.setType(rt, n.getChild().getNodeType());
        } else {
            this.setType(rt, new PrimType("Void"));
        }
    }

    public void visit(FieldReferencing sr) {
        AbstractNode n = (AbstractNode)((Object)sr);
        this.visitChildren(n);
        this.setType(sr, sr.getResultingType());
    }

    public void visit(BoolTypeProducing btp) {
        this.visitChildren((AbstractNode)((Object)btp));
        this.setType(btp, new PrimType("Zoolean"));
    }

    public void visit(IntTypeProducing itp) {
        this.visitChildren((AbstractNode)((Object)itp));
        this.setType(itp, new PrimType("Int"));
    }

    public void visit(FloatTypeProducing ftp) {
        this.visitChildren((AbstractNode)((Object)ftp));
        this.setType(ftp, new PrimType("Float"));
    }

    public void visit(StringTypeProducing stp) {
        this.visitChildren((AbstractNode)((Object)stp));
        this.setType(stp, new RefType("java.lang.String"));
    }

    public void visit(TypeAsserting rtp) {
        this.visitChildren((AbstractNode)((Object)rtp));
        this.setType(rtp, rtp.getType());
    }

    public void visit(UnaryComputeIsh ui) {
        AbstractNode n = (AbstractNode)((Object)ui);
        this.visitChildren(n);
        this.setType(n, n.getChild().getNodeType());
    }

    public void visit(BinaryComputeIsh ei) {
        this.visitBothSame((AbstractNode)((Object)ei));
    }

    public void visit(CastNode n) {
        this.visitChildren(n);
        this.setType(n, n.getAssignTypeNode().getNodeType());
    }

    public void visit(AssignTypeRequiring atr) {
        this.visitBothSame((AbstractNode)((Object)atr));
    }

    public void visitBothSame(AbstractNode n) {
        this.visitChildren(n);
        AbstractNode c1 = n.getChild();
        AbstractNode c2 = c1.getSib();
        if (!c1.getNodeType().equals(c2.getNodeType())) {
            this.err("Semantic error at " + n.dump() + ": assign requires same types" + "\nLeft child:" + c1.dump() + "\nRight child:" + c2.dump());
        }
        this.setType(n, c1.getNodeType());
    }

    public void setType(Object o, Type t) {
        AbstractNode n = (AbstractNode)o;
        n.setNodeType(t);
    }
}

