/*
 * Decompiled with CFR 0.152.
 */
package lab7;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import lab7.NodeDumpable;
import lab7.ReflectiveVisitable;
import lab7.ReflectiveVisitor;
import lab7.Type;
import lab7.Visitable;

public abstract class AbstractNode
implements ReflectiveVisitable,
NodeDumpable {
    private static int nodeNums = 0;
    private int nodeNum;
    private AbstractNode mysib = null;
    private AbstractNode parent = null;
    private AbstractNode child = null;
    private AbstractNode firstSib = this;
    private Type type;
    private static Class objectClass = new Object().getClass();

    public AbstractNode() {
        this.nodeNum = ++nodeNums;
    }

    public AbstractNode makeSibling(AbstractNode sib) {
        if (sib == null) {
            throw new Error("Call to makeSibling supplied null-valued parameter");
        }
        AbstractNode appendAt = this;
        while (appendAt.mysib != null) {
            appendAt = appendAt.mysib;
        }
        appendAt.mysib = sib.firstSib;
        AbstractNode ans = sib.firstSib;
        ans.firstSib = appendAt.firstSib;
        while (ans.mysib != null) {
            ans = ans.mysib;
            ans.firstSib = appendAt.firstSib;
        }
        return ans;
    }

    public AbstractNode adoptChildren(AbstractNode n) {
        if (n != null) {
            if (this.child == null) {
                this.child = n.firstSib;
            } else {
                this.child.makeSibling(n);
            }
        }
        AbstractNode c = this.child;
        while (c != null) {
            c.parent = this;
            c = c.mysib;
        }
        return this;
    }

    public AbstractNode orphan() {
        this.parent = null;
        this.mysib = null;
        this.firstSib = this;
        return this;
    }

    public AbstractNode abandonChildren() {
        this.child = null;
        return this;
    }

    private void setParent(AbstractNode p) {
        this.parent = p;
    }

    public AbstractNode getParent() {
        return this.parent;
    }

    public AbstractNode getSib() {
        return this.mysib;
    }

    public AbstractNode getChild() {
        return this.child;
    }

    public AbstractNode getFirst() {
        return this.firstSib;
    }

    public Type getNodeType() {
        return this.type;
    }

    public void setNodeType(Type type) {
        this.type = type;
    }

    public String getName() {
        return "";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String dump() {
        Type t = this.getNodeType();
        String tString = t != null ? "<" + t.toString() + "> " : "";
        return this.getNodeNum() + ": " + tString + this.whatAmI() + "  \"" + this.toString() + "\"";
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    private static String trimClass(String cl) {
        int dot;
        int trimAt;
        int dollar = cl.lastIndexOf(36);
        int n = trimAt = dollar > (dot = cl.lastIndexOf(46)) ? dollar : dot;
        if (trimAt >= 0) {
            cl = cl.substring(trimAt + 1);
        }
        return cl;
    }

    private static void debugMsg(String s) {
    }

    private static Enumeration interfaces(Class c) {
        Class iClass = c;
        Vector v = new Vector();
        while (iClass != objectClass) {
            AbstractNode.debugMsg("Looking for interface  match in " + iClass.getName());
            Class<?>[] interfaces = iClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                AbstractNode.debugMsg("   trying interface " + interfaces[i]);
                v.addElement(interfaces[i]);
                Class<?>[] superInterfaces = interfaces[i].getInterfaces();
                int j = 0;
                while (j < superInterfaces.length) {
                    AbstractNode.debugMsg("   trying super interface " + superInterfaces[j]);
                    v.addElement(superInterfaces[j]);
                    ++j;
                }
                ++i;
            }
            iClass = iClass.getSuperclass();
        }
        return v.elements();
    }

    public String whatAmI() {
        HashSet<String> s = new HashSet<String>();
        String ans = AbstractNode.trimClass(this.getClass().toString());
        Enumeration e = AbstractNode.interfaces(this.getClass());
        while (e.hasMoreElements()) {
            Class c = (Class)e.nextElement();
            String str = AbstractNode.trimClass(c.toString());
            if (str.equals("DontPrintMe") || str.equals("ReflectiveVisitable")) continue;
            s.add(AbstractNode.trimClass(c.toString()));
        }
        return String.valueOf(ans) + ((Object)s).toString();
    }

    private void internWalk(int level, Visitable v) {
        v.pre(level, this);
        AbstractNode c = this.child;
        while (c != null) {
            c.internWalk(level + 1, v);
            c = c.mysib;
        }
        v.post(level, this);
    }

    @Override
    public final void accept(ReflectiveVisitor v) {
        v.dispatch(this);
    }

    public void walkTree(Visitable v) {
        this.internWalk(0, v);
    }
}

