/*
 * Decompiled with CFR 0.152.
 */
package coursesolutions;

import lab8.SymInfo;
import lab8.Symtab;
import lab8.SymtabInterface;

public class CourseBuildSymtab
extends Symtab
implements SymtabInterface {
    private int nestlevel = 0;
    private Entry[] display = new Entry[100];
    private Entry[] hashTable = new Entry[511];
    public static boolean debug = false;

    public void out(String s) {
        if (debug) {
            super.out(s);
        }
    }

    private void reportLevel() {
        this.out("Nest level now " + this.nestlevel);
    }

    public void incrNestLevel() {
        ++this.nestlevel;
        this.display[this.nestlevel] = null;
        this.reportLevel();
    }

    private void popEntry(Entry e) {
        if (e.isoVar != null) {
            this.replaceEntryBy(e, e.isoVar);
        } else {
            this.deleteEntry(e);
        }
    }

    public void decrNestLevel() {
        Entry e = this.display[this.nestlevel];
        while (e != null) {
            this.popEntry(e);
            e = e.isoLevel;
        }
        --this.nestlevel;
        this.reportLevel();
    }

    private int hash(String s) {
        return Math.abs(s.hashCode()) % this.hashTable.length;
    }

    public int getCurrentNestLevel() {
        return this.nestlevel;
    }

    public SymInfo lookup(String id) {
        Entry found = this.find(this.hash(id), id);
        if (found == null) {
            return null;
        }
        return found.s;
    }

    private Entry find(int loc, String id) {
        Entry e = this.hashTable[loc];
        Entry found = null;
        while (e != null && found == null) {
            if (e.id.equals(id)) {
                found = e;
            }
            e = e.isoHashNext;
        }
        return found;
    }

    private void deleteEntry(Entry e) {
        if (e.isoHashPrev == null) {
            this.hashTable[this.hash((String)e.id)] = e.isoHashNext;
            if (e.isoHashNext != null) {
                e.isoHashNext.isoHashPrev = null;
            }
        } else {
            e.isoHashPrev.isoHashNext = e.isoHashNext;
            if (e.isoHashNext != null) {
                e.isoHashNext.isoHashPrev = e.isoHashPrev;
            }
        }
    }

    private void replaceEntryBy(Entry oldEntry, Entry newEntry) {
        newEntry.isoHashPrev = oldEntry.isoHashPrev;
        newEntry.isoHashNext = oldEntry.isoHashNext;
        if (oldEntry.isoHashPrev == null) {
            this.hashTable[this.hash((String)oldEntry.id)] = newEntry;
        } else {
            oldEntry.isoHashPrev.isoHashNext = newEntry;
        }
        if (oldEntry.isoHashNext != null) {
            oldEntry.isoHashNext.isoHashPrev = newEntry;
        }
    }

    public void enter(String id, SymInfo s) {
        int loc = this.hash(id);
        Entry found = this.find(loc, id);
        Entry ne = new Entry(id, s);
        if (found == null) {
            if (this.hashTable[loc] != null) {
                this.hashTable[loc].isoHashPrev = ne;
                ne.isoHashNext = this.hashTable[loc];
            }
            this.hashTable[loc] = ne;
        } else {
            ne.isoVar = found;
            this.replaceEntryBy(found, ne);
        }
    }

    class Entry {
        String id;
        SymInfo s;
        Entry isoHashNext;
        Entry isoHashPrev;
        Entry isoVar;
        Entry isoLevel;

        public Entry(String id, SymInfo s) {
            this.id = id;
            this.s = s;
            this.isoLevel = CourseBuildSymtab.this.display[CourseBuildSymtab.this.nestlevel];
            ((CourseBuildSymtab)CourseBuildSymtab.this).display[((CourseBuildSymtab)CourseBuildSymtab.this).nestlevel] = this;
        }
    }
}

