/*
 * Decompiled with CFR 0.152.
 */
package coursesolutions;

import lab7.AbstractNode;
import lab7.NodeVisitor;
import lab7.ReflectiveVisitor;
import lab8.BlockIsh;
import lab8.ClassDeclaring;
import lab8.FieldDeclaring;
import lab8.LocalDeclaring;
import lab8.LocalReferencing;
import lab8.MethodDeclaring;
import lab8.ModsAttrs;
import lab8.SymInfo;
import lab8.SymtabInterface;
import lab8.TypeAttrs;

public class CourseSymtabVisitor
extends NodeVisitor {
    private SymtabInterface sfi;

    public CourseSymtabVisitor(SymtabInterface sfi) {
        this.sfi = sfi;
    }

    public void defaultVisit(Object o) {
        AbstractNode n = (AbstractNode)o;
        this.visitChildren(n);
    }

    public void visit(LocalDeclaring l) {
        AbstractNode n = (AbstractNode)l;
        if (this.alreadyThere(l.getName())) {
            this.sfi.err(n, "Error: Duplicate Local Declaration!");
        } else {
            this.sfi.out(n, "Local dcl");
            this.sfi.enter(l.getName(), (SymInfo)new Info(n, null, l.getType()));
            l.setSymInfo(this.sfi.lookup(l.getName()));
        }
    }

    public void visit(FieldDeclaring f) {
        AbstractNode n = (AbstractNode)f;
        if (this.alreadyThere("this." + f.getName())) {
            this.sfi.out(n, "Error: Duplicate Field Declaration!");
        } else {
            this.sfi.out(n, "Field dcl");
            this.sfi.enter("this." + f.getName(), (SymInfo)new Info(n, f.getMods(), f.getType()));
        }
    }

    private boolean alreadyThere(String id) {
        Info inf = (Info)this.sfi.lookup(id);
        return inf != null && inf.level == this.sfi.getCurrentNestLevel();
    }

    private void visitChildrenInNest(AbstractNode n) {
        this.sfi.incrNestLevel();
        this.visitChildren(n);
        this.sfi.decrNestLevel();
    }

    public void visit(ClassDeclaring d) {
        AbstractNode n = (AbstractNode)d;
        if (this.alreadyThere(d.getName())) {
            this.sfi.err(n, "Error: Duplicate Class Declaration!");
        } else {
            this.sfi.out(n, "Class dcl");
        }
        this.visitChildrenInNest(n);
    }

    public void visit(MethodDeclaring m) {
        AbstractNode n = (AbstractNode)m;
        if (this.alreadyThere(m.getName())) {
            this.sfi.err(n, "Error: Duplicate Method Declaration!");
        } else {
            this.sfi.out(n, "Method dcl");
        }
        this.sfi.incrNestLevel();
        m.getParams().accept((ReflectiveVisitor)this);
        this.sfi.incrNestLevel();
        m.getBody().accept((ReflectiveVisitor)this);
        this.sfi.decrNestLevel();
        this.sfi.decrNestLevel();
    }

    public void visit(LocalReferencing r) {
        AbstractNode n = (AbstractNode)r;
        SymInfo si = this.sfi.lookup(r.getId());
        if (si == null) {
            si = this.sfi.lookup("this." + r.getId());
        }
        if (si != null) {
            this.sfi.out(n, "Reference " + si);
            r.setSymInfo(si);
        } else {
            this.sfi.err(n, "Error: Undefined reference!");
        }
    }

    public void visit(BlockIsh b) {
        AbstractNode n = (AbstractNode)b;
        this.sfi.out(n, "Block");
        this.visitChildrenInNest(n);
    }

    public class Info
    implements SymInfo {
        private AbstractNode n;
        private ModsAttrs m;
        private TypeAttrs t;
        private int level;
        private int reg;

        public Info(AbstractNode n, ModsAttrs m, TypeAttrs t) {
            this.n = n;
            this.m = m;
            this.t = t;
            this.level = CourseSymtabVisitor.this.sfi.getCurrentNestLevel();
            this.reg = -1;
        }

        public AbstractNode getDefiningNode() {
            return this.n;
        }

        public ModsAttrs getMods() {
            return this.m;
        }

        public TypeAttrs getType() {
            return this.t;
        }

        public String toString() {
            return this.n.getNodeNum() + ": type " + this.getType() + " mods " + this.getMods() + " reg " + this.getRegister();
        }

        public void setRegister(int reg) {
            this.reg = reg;
        }

        public int getRegister() {
            return this.reg;
        }
    }
}

