/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.PrintStream;

public class Listing {
    private static final String endl = "\n";
    private PrintStream ps;
    private static Listing staticListing;
    private int linenumber;
    private int col;
    private static boolean echoStdErr;

    static {
        echoStdErr = false;
    }

    public Listing(PrintStream printStream, String string) {
        this.ps = printStream;
        staticListing = this;
        this.StartListing(string);
    }

    public Listing(PrintStream printStream) {
        this(printStream, "");
    }

    public static Listing get() {
        return staticListing;
    }

    public void StartListing(String string) {
        this.out(string);
        this.linenumber = 0;
        this.col = 1;
        this.NewLine(1);
    }

    public void EndListing(String string) {
        this.out(string);
    }

    public int getLineNumber() {
        return this.linenumber;
    }

    public int getColNumber() {
        return this.col;
    }

    private static String makestrlen(String string, int n) {
        String string2 = string;
        while (string2.length() < n) {
            string2 = " " + string2;
        }
        return string2;
    }

    private static String makestrlen(int n, int n2) {
        return Listing.makestrlen(String.valueOf(n), n2);
    }

    public void NewLine(int n) {
        this.linenumber += n;
        if (n > 0) {
            this.col = 1;
            this.out(endl + Listing.makestrlen(this.linenumber, 7) + ": ");
        } else {
            this.out("\n*" + Listing.makestrlen(this.linenumber, 6) + ": ");
        }
    }

    public void echo(String string) {
        this.col += string.length();
        this.out(string);
    }

    public void StartMessage() {
        this.InsertMessage("^^^");
    }

    private void InsertMessage(String string) {
        this.NewLine(0);
        int n = 1;
        while (n <= this.col) {
            this.out(" ");
            ++n;
        }
        this.out(string);
    }

    public void EndMessage() {
        this.InsertMessage("");
    }

    public void EmitMessage(String string) {
        this.StartMessage();
        this.out(string);
        if (echoStdErr) {
            System.err.println(string);
        }
        this.EndMessage();
    }

    public void warning(String string) {
        this.EmitMessage("Warning: " + string);
    }

    public void oops(String string) {
        this.EmitMessage(string);
        this.EndListing("End.");
        System.err.println("Aborting due to error at line " + this.linenumber + " column " + this.col + endl);
        System.exit(1);
    }

    private void out(String string) {
        this.ps.print(string);
    }
}

