/*
 * Decompiled with CFR 0.152.
 */
package coursesolutions;

import hw4.ArgIsh;
import hw4.AssignIsh;
import hw4.ClassDeclaring;
import hw4.CompareIsh;
import hw4.ComputeIsh;
import hw4.ConstantProducing;
import hw4.FieldReferencing;
import hw4.IfIsh;
import hw4.InvokeIsh;
import hw4.InvokeReference;
import hw4.LocalDeclaring;
import hw4.LocalReferencing;
import hw4.MethodDeclaring;
import hw4.NullIsh;
import hw4.ParamIsh;
import hw4.ShortAndIsh;
import hw4.ShortOrIsh;
import hw4.StaticReferencing;
import hw4.ThisIsh;
import hw4.WhileIsh;
import lab7.AbstractNode;
import lab7.NodeDumpable;
import lab7.NodeVisitor;
import lab7.Type;

public class CourseProjectCodeGenVisitor
extends NodeVisitor {
    private void emit(String s) {
        this.out(System.out, s);
    }

    private void emit(NodeDumpable a, String s) {
        this.emit("; " + a.dump());
        this.emit(s);
    }

    private void emitComment(String s) {
        this.emit("; " + s);
    }

    private void skip(int num) {
        int i = 0;
        while (i < num) {
            this.emit("");
            ++i;
        }
    }

    private void emitLabel(Label l) {
        this.emit(l.def());
    }

    public void visit(ClassDeclaring c) {
        this.emitComment("CS431 automatically generated code file");
        this.emitComment("");
        this.emit(c, ".class public TestClasses/" + c.getName());
        this.emit(".super java/lang/Object");
        this.emit("; standard initializer\n\n.method public <init>()V\n   aload_0\n   invokenonvirtual java/lang/Object/<init>()V\n   return\n.end method\n\n");
        this.emitComment("dummy main to call our main because we don't handle arrays");
        this.skip(4);
        this.emit(".method public static main([Ljava/lang/String;)V\n   .limit locals 1\n   .limit stack  4\n   invokestatic TestClasses/" + c.getName() + "/main431()V\n" + "   return\n" + ".end method\n\n");
        this.visitChildren((AbstractNode)((Object)c));
    }

    private static char typeLetter(AbstractNode n) {
        Type t = n.getNodeType();
        char ans = 'a';
        if (t.toString().equals("I") || t.toString().equals("Z")) {
            ans = 'i';
        }
        return ans;
    }

    public void visit(LocalReferencing r) {
        this.emit(r, String.valueOf(CourseProjectCodeGenVisitor.typeLetter((AbstractNode)((Object)r))) + "load " + r.getSymInfo().getRegister());
    }

    public void visit(ThisIsh t) {
        this.emit(t, String.valueOf(CourseProjectCodeGenVisitor.typeLetter((AbstractNode)((Object)t))) + "load_0");
    }

    public void visit(CompareIsh c) {
        AbstractNode n = (AbstractNode)((Object)c);
        this.emitComment("Compare code for " + n.dump());
        this.visitChildren(n);
        Label setOne = new Label();
        Label setEnd = new Label();
        this.emit("if_icmp" + c.getCompare() + " " + setOne.use());
        this.emit("iconst_0");
        this.emit("goto " + setEnd.use());
        this.emitLabel(setOne);
        this.emit("iconst_1");
        this.emitLabel(setEnd);
    }

    public void visit(AssignIsh a) {
        AbstractNode n = (AbstractNode)((Object)a);
        this.emitComment(n.dump() + " start of assign");
        n.getChild().getSib().accept(this);
        new AssignTargVisitor().performVisit(n.getChild());
        this.emitComment(n.dump() + " end of assign");
    }

    public void visit(ShortOrIsh soi) {
        AbstractNode n = (AbstractNode)((Object)soi);
        n.getChild().accept(this);
        Label skip = new Label();
        this.emit("dup");
        this.emit(soi, "ifne " + skip.use());
        n.getChild().getSib().accept(this);
        this.emit("ior");
        this.emitLabel(skip);
    }

    public void visit(ShortAndIsh soi) {
        AbstractNode n = (AbstractNode)((Object)soi);
        n.getChild().accept(this);
        Label skip = new Label();
        this.emit("dup");
        this.emit(soi, "ifeq " + skip.use());
        n.getChild().getSib().accept(this);
        this.emit("iand");
        this.emitLabel(skip);
    }

    public void visit(NullIsh n) {
        this.emit(n, "aconst_null");
    }

    public void visit(ConstantProducing c) {
        this.emit(c, "ldc " + c.getConstant());
    }

    public void visit(ComputeIsh c) {
        AbstractNode n = (AbstractNode)((Object)c);
        this.visitChildren(n);
        this.emit(n, "i" + c.getOperation());
    }

    public void visit(MethodDeclaring m) {
        AbstractNode n = (AbstractNode)((Object)m);
        SigVisitor sv = new SigVisitor();
        sv.performVisit(n.getChild());
        this.emit(".method " + (m.getMods().isPublic() ? "public " : "private ") + (m.getMods().isStatic() ? "static " : "") + m.getName() + "(" + sv.getAnswer() + ")" + m.getType().getTypeString());
        this.emit(".limit locals 10");
        this.emit(".limit stack  30");
        int nextReg = m.getMods().isStatic() ? 0 : 1;
        new RegisterAssignVisitor(nextReg).performVisit(n);
        this.visitChildren(n);
        this.emit("return");
        this.emit(".end method\n\n");
    }

    private static String type2class(Type t) {
        return CourseProjectCodeGenVisitor.type2class(t.toString());
    }

    private static String type2class(String s) {
        return s.substring(0, s.length() - 1).substring(1);
    }

    public void visit(FieldReferencing fr) {
        AbstractNode n = (AbstractNode)((Object)fr);
        n.getChild().accept(this);
        String cl = CourseProjectCodeGenVisitor.type2class(n.getChild().getNodeType().toString());
        this.emit(n, "getfield " + cl + "/" + fr.getFieldName() + " " + fr.getResultingType());
    }

    public void visit(StaticReferencing sr) {
        AbstractNode n = (AbstractNode)((Object)sr);
        String cl = CourseProjectCodeGenVisitor.type2class(sr.getClassName().toString());
        this.emit(n, "getstatic " + cl + "/" + sr.getFieldName() + " " + sr.getResultingType());
    }

    public void visit(WhileIsh wh) {
        AbstractNode n = (AbstractNode)((Object)wh);
        this.emitComment("While code for " + n.dump());
        Label again = new Label();
        Label end = new Label();
        this.emitLabel(again);
        wh.getPredicate().accept(this);
        this.emit("ifeq " + end.use());
        wh.getBody().accept(this);
        this.emit("goto " + again.use());
        this.emitLabel(end);
    }

    public void visit(IfIsh ifish) {
        AbstractNode n = (AbstractNode)((Object)ifish);
        Label tlabel = new Label();
        Label endlabel = new Label();
        this.emitComment("if code generated for " + n.dump());
        ifish.getPredicate().accept(this);
        this.emit("ifne " + tlabel.use());
        ifish.getFalsePart().accept(this);
        this.emit("goto " + endlabel.use());
        this.emitLabel(tlabel);
        ifish.getTruePart().accept(this);
        this.emitLabel(endlabel);
    }

    public void visit(InvokeIsh inv) {
        InvokeReference ir = inv.methodNode();
        AbstractNode n = (AbstractNode)((Object)inv);
        this.emitComment("Generating code for the invoke " + n.dump());
        this.emitComment("Visiting to push \"this\" possibly");
        if (!ir.isStaticInvoke()) {
            ir.getThisNode().accept(this);
        }
        this.emitComment("Computing and pushing arguments next:");
        inv.paramsNode().accept(this);
        this.emitComment("End of argument pushing");
        String returnType = ir.getReturnType().toString();
        SigVisitor sv = new SigVisitor();
        sv.performVisit(inv.paramsNode());
        String argTypes = sv.getAnswer();
        this.emit(n, "invoke" + (ir.isStaticInvoke() ? "static" : "virtual") + " " + CourseProjectCodeGenVisitor.type2class(ir.getClassType()) + "/" + ir.getMethodName() + "(" + argTypes + ")" + returnType);
    }

    @Override
    public void defaultVisit(Object o) {
        AbstractNode n = (AbstractNode)o;
        this.visitChildren(n);
    }

    protected class AssignTargVisitor
    extends NodeVisitor {
        protected AssignTargVisitor() {
        }

        public void visit(ThisIsh t) {
            AbstractNode n = (AbstractNode)((Object)t);
            CourseProjectCodeGenVisitor.this.emitComment("Assign target resolved to this:");
            CourseProjectCodeGenVisitor.this.emit(String.valueOf(CourseProjectCodeGenVisitor.typeLetter(n)) + "store_0");
        }

        public void visit(LocalReferencing lr) {
            AbstractNode n = (AbstractNode)((Object)lr);
            CourseProjectCodeGenVisitor.this.emitComment("Assign target resolved to local:");
            CourseProjectCodeGenVisitor.this.emit(String.valueOf(CourseProjectCodeGenVisitor.typeLetter(n)) + "store " + lr.getSymInfo().getRegister());
        }

        public void visit(FieldReferencing fr) {
            AbstractNode n = (AbstractNode)((Object)fr);
            CourseProjectCodeGenVisitor.this.emitComment("Assign target resolved to putfield:");
            n.getChild().accept(CourseProjectCodeGenVisitor.this);
            String cl = CourseProjectCodeGenVisitor.type2class(n.getChild().getNodeType().toString());
            CourseProjectCodeGenVisitor.this.emit("swap");
            CourseProjectCodeGenVisitor.this.emit(n, "putfield " + cl + "/" + fr.getFieldName() + " " + fr.getResultingType());
        }

        public void visit(StaticReferencing sr) {
            AbstractNode n = (AbstractNode)((Object)sr);
            CourseProjectCodeGenVisitor.this.emitComment("Assign target resolved to putstatic:");
            String cl = CourseProjectCodeGenVisitor.type2class(sr.getClassName().toString());
            CourseProjectCodeGenVisitor.this.emit(n, "putstatic " + cl + "/" + sr.getFieldName() + " " + sr.getResultingType());
        }
    }

    static class Label {
        private static int num = 1000;
        private int mynum = ++num;

        public String use() {
            return "L" + this.mynum;
        }

        public String def() {
            return "L" + this.mynum + ":";
        }
    }

    protected class RegisterAssignVisitor
    extends NodeVisitor {
        private int reg;

        public RegisterAssignVisitor(int reg) {
            this.reg = reg;
        }

        public void visit(LocalDeclaring ld) {
            AbstractNode nld = (AbstractNode)((Object)ld);
            ld.getSymInfo().setRegister(this.reg++);
        }

        @Override
        public void defaultVisit(Object o) {
            this.visitChildren((AbstractNode)o);
        }

        public int getLastRegisterNumber() {
            return this.reg;
        }
    }

    protected class SigVisitor
    extends NodeVisitor {
        private String answer = "";

        protected SigVisitor() {
        }

        public void visit(ParamIsh args) {
            this.visitChildren((AbstractNode)((Object)args));
        }

        public void visit(ArgIsh args) {
            this.visitChildren((AbstractNode)((Object)args));
        }

        public void visit(LocalDeclaring ld) {
            this.answer = String.valueOf(this.answer) + ld.getType().toString();
        }

        @Override
        public void defaultVisit(Object o) {
            AbstractNode n = (AbstractNode)o;
            this.answer = String.valueOf(this.answer) + n.getNodeType().toString();
        }

        public String getAnswer() {
            return this.answer;
        }
    }
}

