/*
 * Decompiled with CFR 0.152.
 */
package coursesolutions;

import hw4.BlockIsh;
import hw4.ClassDeclaring;
import hw4.FieldDeclaring;
import hw4.LocalDeclaring;
import hw4.LocalReferencing;
import hw4.MethodDeclaring;
import hw4.ModsAttrs;
import hw4.SymInfo;
import hw4.SymtabInterface;
import hw4.TypeAttrs;
import lab7.AbstractNode;
import lab7.NodeVisitor;

public class CourseSymtabVisitor
extends NodeVisitor {
    private SymtabInterface sfi;

    public CourseSymtabVisitor(SymtabInterface sfi) {
        this.sfi = sfi;
    }

    @Override
    public void defaultVisit(Object o) {
        AbstractNode n = (AbstractNode)o;
        this.visitChildren(n);
    }

    public void visit(LocalDeclaring l) {
        AbstractNode n = (AbstractNode)((Object)l);
        if (this.alreadyThere(l.getName())) {
            this.sfi.err(n, "Error: Duplicate Local Declaration!");
        } else {
            this.sfi.out(n, "Local dcl");
            this.sfi.enter(l.getName(), new Info(n, null, l.getType()));
            l.setSymInfo(this.sfi.lookup(l.getName()));
        }
    }

    public void visit(FieldDeclaring f) {
        AbstractNode n = (AbstractNode)((Object)f);
        if (this.alreadyThere("this." + f.getName())) {
            this.sfi.out(n, "Error: Duplicate Field Declaration!");
        } else {
            this.sfi.out(n, "Field dcl");
            this.sfi.enter("this." + f.getName(), new Info(n, f.getMods(), f.getType()));
        }
    }

    private boolean alreadyThere(String id) {
        Info inf = (Info)this.sfi.lookup(id);
        return inf != null && inf.level == this.sfi.getCurrentNestLevel();
    }

    private void visitChildrenInNest(AbstractNode n) {
        this.sfi.incrNestLevel();
        this.visitChildren(n);
        this.sfi.decrNestLevel();
    }

    public void visit(ClassDeclaring d) {
        AbstractNode n = (AbstractNode)((Object)d);
        if (this.alreadyThere(d.getName())) {
            this.sfi.err(n, "Error: Duplicate Class Declaration!");
        } else {
            this.sfi.out(n, "Class dcl");
        }
        this.visitChildrenInNest(n);
    }

    public void visit(MethodDeclaring m) {
        AbstractNode n = (AbstractNode)((Object)m);
        if (this.alreadyThere(m.getName())) {
            this.sfi.err(n, "Error: Duplicate Method Declaration!");
        } else {
            this.sfi.out(n, "Method dcl");
        }
        this.sfi.incrNestLevel();
        m.getParams().accept(this);
        this.sfi.incrNestLevel();
        m.getBody().accept(this);
        this.sfi.decrNestLevel();
        this.sfi.decrNestLevel();
    }

    public void visit(LocalReferencing r) {
        AbstractNode n = (AbstractNode)((Object)r);
        SymInfo si = this.sfi.lookup(r.getId());
        if (si == null) {
            si = this.sfi.lookup("this." + r.getId());
        }
        if (si != null) {
            this.sfi.out(n, "Reference " + si);
            r.setSymInfo(si);
        } else {
            this.sfi.err(n, "Error: Undefined reference!");
        }
    }

    public void visit(BlockIsh b) {
        AbstractNode n = (AbstractNode)((Object)b);
        this.sfi.out(n, "Block");
        this.visitChildrenInNest(n);
    }

    public class Info
    implements SymInfo {
        private AbstractNode n;
        private ModsAttrs m;
        private TypeAttrs t;
        private int level;
        private int reg;

        public Info(AbstractNode n, ModsAttrs m, TypeAttrs t) {
            this.n = n;
            this.m = m;
            this.t = t;
            this.level = CourseSymtabVisitor.this.sfi.getCurrentNestLevel();
            this.reg = -1;
        }

        @Override
        public AbstractNode getDefiningNode() {
            return this.n;
        }

        @Override
        public ModsAttrs getMods() {
            return this.m;
        }

        @Override
        public TypeAttrs getType() {
            return this.t;
        }

        public String toString() {
            return this.n.getNodeNum() + ": type " + this.getType() + " mods " + this.getMods() + " reg " + this.getRegister();
        }

        @Override
        public void setRegister(int reg) {
            this.reg = reg;
        }

        @Override
        public int getRegister() {
            return this.reg;
        }
    }
}

