/*
 * Decompiled with CFR 0.152.
 */
package lab7;

import java.io.PrintStream;
import lab7.AbstractNode;
import lab7.ReflectiveVisitor;

public abstract class NodeVisitor
extends ReflectiveVisitor {
    protected int level = 0;
    protected PrintStream ps = System.err;

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public void defaultVisit(Object o) {
        throw new Error("The visitor " + this.getClass() + " lacks the method visit(" + o.getClass() + ")");
    }

    protected final void visitChildren(AbstractNode n) {
        if (n == null) {
            return;
        }
        ++this.level;
        AbstractNode c = n.getChild();
        while (c != null) {
            c.accept(this);
            c = c.getSib();
        }
        --this.level;
    }

    public void err(String s) {
        this.err(this.ps, s);
    }

    public void err(PrintStream ps, String s) {
        this.out(ps, "Error " + s);
        throw new Error(s);
    }

    public void out(String s) {
        this.out(this.ps, s);
    }

    public void out(PrintStream ps, String s) {
        String tab = "";
        int i = 1;
        while (i <= this.level) {
            tab = String.valueOf(tab) + "  ";
            ++i;
        }
        ps.println(String.valueOf(tab) + s);
    }
}

