/*
 * Decompiled with CFR 0.152.
 */
package lab7;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lab7.AbstractNode;

public abstract class ReflectiveVisitor {
    public static boolean debug = false;
    private static Class objectClass = new Object().getClass();

    public abstract void defaultVisit(Object var1);

    private void debugMsg(String s) {
        if (debug) {
            System.err.println(s);
        }
    }

    public void perform(AbstractNode n) {
        n.accept(this);
    }

    public final ReflectiveVisitor performVisit(AbstractNode n) {
        this.perform(n);
        return this;
    }

    public final void dispatch(Object o) {
        Method m = this.getBestMethodFor(o);
        try {
            m.invoke((Object)this, o);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.err);
            throw new Error("Method " + m + " aborting, bad access: " + e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw new Error(e.getCause());
            }
            e.printStackTrace(System.err);
            throw new Error("Method " + m + " aborting: " + e + " cause: " + e.getCause());
        }
    }

    protected Method getBestMethodFor(Object o) {
        Class<?> nodeClass = o.getClass();
        Method ans = null;
        Class<?> c = nodeClass;
        while (c != objectClass && ans == null) {
            this.debugMsg("Looking for class match for " + c.getName());
            try {
                ans = this.getClass().getMethod("visit", c);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            c = c.getSuperclass();
        }
        Class<?> iClass = nodeClass;
        while (ans == null && iClass != objectClass) {
            this.debugMsg("Looking for interface  match in " + iClass.getName());
            Class<?>[] interfaces = iClass.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                this.debugMsg("   trying interface " + interfaces[i]);
                try {
                    ans = this.getClass().getMethod("visit", interfaces[i]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                Class<?>[] superInterfaces = interfaces[i].getInterfaces();
                int j = 0;
                while (j < superInterfaces.length && ans == null) {
                    this.debugMsg("   trying super interface " + superInterfaces[j]);
                    try {
                        ans = this.getClass().getMethod("visit", superInterfaces[j]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
            iClass = iClass.getSuperclass();
        }
        if (ans == null) {
            try {
                this.debugMsg("Giving up");
                ans = this.getClass().getMethod("defaultVisit", new Object().getClass());
            }
            catch (NoSuchMethodException e) {
                this.debugMsg("Cannot happen -- could not find defaultVisit(Object)");
                e.printStackTrace(System.err);
                System.exit(-1);
            }
        }
        this.debugMsg("Best method for " + o + " is " + ans);
        return ans;
    }
}

