package autogen;

import java_cup.runtime.SymbolFactory;

%%

%public
%{
   private SymbolFactory sf;
   public Yylex (java.io.InputStream r, SymbolFactory sf)
   {
     this (r);
     this.sf = sf;
   }
%}
%eofval{
  return sf.newSymbol ("EOF", sym.EOF);
%eofval}

%unicode

%cup
%cupdebug

%char
%column
%line


ALPHA=[A-Za-z_]
DIGIT=[0-9]
NONNEWLINE_WHITE_SPACE_CHAR=[\ \t\b\012]
NEWLINE=\r|\n|\r\n
IDENT={ALPHA}({ALPHA}|{DIGIT}|_)*

%% 

<YYINITIAL> {
  "(" { return sf.newSymbol ("LeftParen", sym.LPAREN); }
  ")" { return sf.newSymbol ("RightParen", sym.RPAREN); }
  ";" { return sf.newSymbol ("Semicolon", sym.SEMI); }
  "=" { return sf.newSymbol ("Equals", sym.EQUALS); }
  "+" { return sf.newSymbol ("Plus", sym.PLUS); }
  "-" { return sf.newSymbol ("Minus", sym.MINUS); }
  "*" { return sf.newSymbol ("Times", sym.TIMES); }
  "/" { return sf.newSymbol ("Divide", sym.DIVIDE); }

  {NONNEWLINE_WHITE_SPACE_CHAR}+ { }

  {IDENT}
    { return sf.newSymbol ("Identifier", sym.IDENTIFIER, yytext ()); }

  {DIGIT}+
    {
      int i = Integer.parseInt (yytext ());
      return sf.newSymbol ("IntegerConstant", sym.INTEGER_CONSTANT, new Integer (i));
    }
}

{NEWLINE} { }

. {
  System.out.println ("Illegal character: <" + yytext () + ">");
}

