package main;
public class ExpBinOp extends Exp
{
  public enum BinOp { 
    PLUS ("+"),
    MINUS ("-"),
    TIMES ("*"),
    DIVIDE ("/"),
    ;

    final String string;

    BinOp (String string) 
    {
      this.string = string;
    }

    public String toString ()
    {
      return string;
    }
  };


  public final BinOp op;
  public final Exp left;
  public final Exp right;


  public ExpBinOp (BinOp op, Exp left, Exp right)
  {
    this.op = op;
    this.left = left;
    this.right = right;
  }


  public String toString ()
  {
    return "(" + left + " " + op + " " + right + ")";
  }
}
