package main;
import java.util.List;
import java.util.HashMap;
import java.util.Map;


public class Interpreter
{
  public Map<String, Integer> evaluateDecls (List<Decl> decls)
  {
    Map<String, Integer> bindings = new HashMap<String, Integer> ();
    
    for (Decl decl : decls) {
      int value = evaluateExp (bindings, decl.exp);
      bindings.put (decl.var, new Integer (value));
    }
    
    return bindings;
  }


  int evaluateExp (Map<String, Integer> bindings, Exp exp) 
  {
    if (exp instanceof ExpInt) {
      ExpInt expI = (ExpInt) exp;
      return expI.value;

    } else if (exp instanceof ExpVar) {
      ExpVar expV = (ExpVar) exp;
      Integer value = bindings.get (expV.var);
      if (value == null) {
        throw new RuntimeException ("Variable " + expV.var + " not defined");
      } else {
        return value.intValue ();
      }

    } else if (exp instanceof ExpBinOp) {
      ExpBinOp expB = (ExpBinOp) exp;
      int left = evaluateExp (bindings, expB.left);
      int right = evaluateExp (bindings, expB.right);
      if (expB.op.equals (ExpBinOp.BinOp.PLUS)) {
        return left+right;
      } else if (expB.op.equals (ExpBinOp.BinOp.MINUS)) {
        return left-right;
      } else if (expB.op.equals (ExpBinOp.BinOp.TIMES)) {
        return left*right;
      } else if (expB.op.equals (ExpBinOp.BinOp.DIVIDE)) {
        return left/right;
      } else {
        throw new RuntimeException ("Missing case for BinOp " + expB.op);
      }

    } else {
      throw new RuntimeException ("Missing case for Exp " + exp);
    }
  }
}
