package main;
import java.util.List;
import java.util.Map;

import autogen.Parser;
import autogen.Yylex;

import java_cup.runtime.*;


public class Main
{
  public static void main (String[] args) 
    throws Exception
  {
    SymbolFactory sf = new ComplexSymbolFactory ();
    Yylex lexer;
    if (args.length == 0) {
      lexer = new Yylex (System.in, sf);
    } else {
      lexer = new Yylex (new java.io.FileInputStream (args[0]), sf);
    }
    Parser parser = new Parser (lexer, sf);

    Symbol symbol = parser.parse ();

    @SuppressWarnings("unchecked")
	List<Decl> decls = (List<Decl>) symbol.value;
    for (Decl decl : decls) {
      System.out.println (decl);
    }

    System.out.println ();

    Interpreter interpreter = new Interpreter ();
    Map<String, Integer> bindings = interpreter.evaluateDecls (decls);
    for (String var : bindings.keySet ()) {
      System.out.println (var + " = " + bindings.get (var));
    }
  }
}

