/*
 * Decompiled with CFR 0.152.
 */
package project.model;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Queue<Item>
implements Iterable<Item> {
    private int N;
    private Node first = null;
    private Node last = null;

    public boolean isEmpty() {
        return this.first == null;
    }

    public int length() {
        return this.N;
    }

    public int size() {
        return this.N;
    }

    public void enqueue(Item item) {
        Node x = new Node();
        x.item = item;
        if (this.isEmpty()) {
            this.first = x;
            this.last = x;
        } else {
            this.last.next = x;
            this.last = x;
        }
        ++this.N;
    }

    public Item dequeue() {
        if (this.isEmpty()) {
            throw new RuntimeException("Queue underflow");
        }
        Object item = this.first.item;
        this.first = this.first.next;
        --this.N;
        return (Item)item;
    }

    public Item peek() {
        return (Item)this.first.item;
    }

    public String toString() {
        String s = "";
        Node x = this.first;
        while (x != null) {
            s = s + x.item + " ";
            x = x.next;
        }
        return s;
    }

    @Override
    public Iterator<Item> iterator() {
        return new QueueIterator();
    }

    private class QueueIterator
    implements Iterator<Item> {
        private Node current;

        private QueueIterator() {
            this.current = Queue.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }

    private class Node {
        private Item item;
        private Node next;

        private Node() {
        }
    }
}

