// Exercise 1.2.19 (Solution published at http://algs4.cs.princeton.edu/)
package algs12;
import java.util.Arrays;
import java.util.Comparator;
import stdlib.*;
/* ***********************************************************************
 *  Compilation:  javac Date.java
 *  Execution:    java Date
 *
 *  An immutable data type for dates.
 *
 *************************************************************************/

public class Date implements Comparable<Date> {
	private static final int[] DAYS = { 0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

	private final int month;   // month (between 1 and 12)
	private final int day;     // day   (between 1 and DAYS[month]
	private final int year;    // year

	// do bounds-checking to ensure object represents a valid date
	public Date(int month, int day, int year) {
		if (!isValid(month, day, year)) throw new Error("Invalid date");
		this.month = month;
		this.day   = day;
		this.year  = year;
	}

	// create new data by parsing from string of the form mm/dd/yy
	public Date(String date) {
		String[] fields = date.split("/");
		if (fields.length != 3) {
			throw new Error("Date parse error");
		}
		month = Integer.parseInt(fields[0]);
		day   = Integer.parseInt(fields[1]);
		year  = Integer.parseInt(fields[2]);
		if (!isValid(month, day, year)) throw new Error("Invalid date");
	}

	public int month() { return month; }
	public int day()   { return day;   }
	public int year()  { return year;  }


	// is the given date valid?
	private static boolean isValid(int m, int d, int y) {
		if (m < 1 || m > 12)      return false;
		if (d < 1 || d > DAYS[m]) return false;
		if (m == 2 && d == 29 && !isLeapYear(y)) return false;
		return true;
	}

	// is y a leap year?
	private static boolean isLeapYear(int y) {
		if (y % 400 == 0) return true;
		if (y % 100 == 0) return false;
		return y % 4 == 0;
	}

	// return the next Date
	public Date next() {
		if (isValid(month, day + 1, year))    return new Date(month, day + 1, year);
		else if (isValid(month + 1, 1, year)) return new Date(month + 1, 1, year);
		else                                  return new Date(1, 1, year + 1);
	}


	// is this Date after b?
	public boolean isAfter(Date b) {
		return compareTo(b) > 0;
	}

	// is this Date a before b?
	public boolean isBefore(Date b) {
		return compareTo(b) < 0;
	}

	// compare this Date to that one
	public int compareTo(Date that) {
		if (this.year  < that.year)  return -1;
		if (this.year  > that.year)  return +1;
		if (this.month < that.month) return -1;
		if (this.month > that.month) return +1;
		if (this.day   < that.day)   return -1;
		if (this.day   > that.day)   return +1;
		return 0;
	}

	// return a string representation of this date
	public String toString() {
		return month + "/" + day + "/" + year;
	}

	// is this Date equal to x?
	public boolean equals(Object x) {
		if (x == this) return true;
		if (x == null) return false;
		if (x.getClass() != this.getClass()) return false;
		Date that = (Date) x;
		return (this.month == that.month) && (this.day == that.day) && (this.year == that.year);
	}

	public int hashCode() {
		int hash = 17;
		hash = 31*hash + Integer.hashCode (month);
		hash = 31*hash + Integer.hashCode (day);
		hash = 31*hash + Integer.hashCode (year);
		return hash;
	}



	// A stupid class!
	private static class MyComp implements Comparator<Date>{
		public int compare (Date o1, Date o2) {
			return o2.compareTo (o1);
		}		
	}
	
	// sample client for testing
	public static void main(String[] args) {
		// using the stupid class:
		Comparator<Date> c1 = new MyComp ();

		// using an inner class:
		Comparator<Date> c2 = new Comparator<Date>() {
			public int compare (Date o1, Date o2) {
				return o2.compareTo (o1);
			}
		};
		
		// using a lambda expression:
		Comparator<Date> c3 = (o1, o2) -> o2.compareTo (o1);	
		
		Date[] dates = new Date[] { new Date(2, 25, 2004), new Date(2, 25, 2003), } ;
		StdOut.println (Arrays.binarySearch (dates, new Date(2, 25, 2003), c1));
		
//		Date today = new Date(2, 25, 2004);
//		StdOut.println(today);
//		for (int i = 0; i < 10; i++) {
//			today = today.next();
//			StdOut.println(today);
//		}
//
//		StdOut.println(today.isAfter(today.next()));
//		StdOut.println(today.isAfter(today));
//		StdOut.println(today.next().isAfter(today));
//
//
//		Date birthday = new Date(10, 16, 1971);
//		StdOut.println(birthday);
//		for (int i = 0; i < 10; i++) {
//			birthday = birthday.next();
//			StdOut.println(birthday);
//		}
	}

}
