package algs14;
import stdlib.*;
import java.util.Arrays;
/* ***********************************************************************
 *  Compilation:  javac ThreeSumFast.java
 *  Execution:    java ThreeSumFast input.txt
 *  Data files:   http://algs4.cs.princeton.edu/14analysis/1Kints.txt
 *                http://algs4.cs.princeton.edu/14analysis/2Kints.txt
 *                http://algs4.cs.princeton.edu/14analysis/4Kints.txt
 *                http://algs4.cs.princeton.edu/14analysis/8Kints.txt
 *                http://algs4.cs.princeton.edu/14analysis/16Kints.txt
 *                http://algs4.cs.princeton.edu/14analysis/32Kints.txt
 *                http://algs4.cs.princeton.edu/14analysis/1Mints.txt
 *
 *  A program with N^2 log N running time. Read in N integers
 *  and counts the number of triples that sum to exactly 0.
 *
 *  Limitations
 *  -----------
 *     - we ignore integer overflow
 *     - doesn't handle case when input has duplicates
 *
 *
 *  % java ThreeSumFast 1Kints.txt
 *  70
 *
 *  % java ThreeSumFast 2Kints.txt
 *  528
 *
 *  % java ThreeSumFast 4Kints.txt
 *  4039
 *
 *  % java ThreeSumFast 8Kints.txt
 *  32074
 *
 *  % java ThreeSumFast 16Kints.txt
 *  255181
 *
 *  % java ThreeSumFast 32Kints.txt
 *  2052358
 *
 *************************************************************************/

public class ThreeSumFast {

	// print distinct triples (i, j, k) such that a[i] + a[j] + a[k] = 0
	public static void printAll(int[] a) {
		int N = a.length;
		Arrays.sort(a);
		for (int i = 0; i < N; i++) {
			for (int j = i+1; j < N; j++) {
				int k = Arrays.binarySearch(a, -(a[i] + a[j]));
				if (k > j) StdOut.println(a[i] + " " + a[j] + " " + a[k]);
			}
		}
	}

	// return number of distinct triples (i, j, k) such that a[i] + a[j] + a[k] = 0
	public static int count(int[] a) {
		int N = a.length;
		Arrays.sort(a);
		int cnt = 0;
		for (int i = 0; i < N; i++) {
			for (int j = i+1; j < N; j++) {
				int k = Arrays.binarySearch(a, -(a[i] + a[j]));
				if (k > j) cnt++;
			}
		}
		return cnt;
	}

	public static void main(String[] args)  {
		//args = new String[] { "data/2Kints.txt" };

		int[] a = new In(args[0]).readAllInts();
		int cnt = count(a);
		StdOut.println(cnt);
	}
}
