package algs44;
/* ***********************************************************************
 *  Compilation:  javac DijkstraAllPairsSP.java
 *  Dependencies: EdgeWeightedDigraph.java Dijkstra.java
 *
 *  Dijkstra's algorithm run from each vertex.
 *  Takes time proportional to E V log V and space proportional to EV.
 *
 *************************************************************************/

public class DijkstraAllPairsSP {
	private final DijkstraSP[] all;

	public DijkstraAllPairsSP(EdgeWeightedDigraph G) {
		all  = new DijkstraSP[G.V()];
		for (int v = 0; v < G.V(); v++)
			all[v] = new DijkstraSP(G, v);
	}

	Iterable<DirectedEdge> path(int s, int t) {
		return all[s].pathTo(t);
	}

	double dist(int s, int t) {
		return all[s].distTo(t);
	}
}
